/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.HtmlOccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;

public class XmlOccurrenceMarker
implements OccurrenceMarker {
    private static final char[] CLOSE_TAG_START = new char[]{'<', '/'};
    private static final char[] TAG_SELF_CLOSE = new char[]{'/', '>'};

    @Override
    public Token getTokenToMark(RSyntaxTextArea textArea) {
        return HtmlOccurrenceMarker.getTagNameTokenForCaretOffset(textArea, this);
    }

    @Override
    public boolean isValidType(RSyntaxTextArea textArea, Token t2) {
        return textArea.getMarkOccurrencesOfTokenType(t2.getType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void markOccurrences(RSyntaxDocument doc, Token t2, RSyntaxTextAreaHighlighter h2, SmartHighlightPainter p2) {
        char[] lexeme = t2.getLexeme().toCharArray();
        int tokenOffs = t2.getOffset();
        Element root = doc.getDefaultRootElement();
        int lineCount = root.getElementCount();
        int curLine = root.getElementIndex(t2.getOffset());
        int depth = 0;
        boolean found = false;
        boolean forward = true;
        for (t2 = doc.getTokenListForLine(curLine); t2 != null && t2.isPaintable(); t2 = t2.getNextToken()) {
            if (t2.getType() != 25) continue;
            if (t2.isSingleChar('<') && t2.getOffset() + 1 == tokenOffs) {
                found = true;
                break;
            }
            if (!t2.is(CLOSE_TAG_START) || t2.getOffset() + 2 != tokenOffs) continue;
            found = true;
            forward = false;
            break;
        }
        if (!found) {
            return;
        }
        if (forward) {
            t2 = t2.getNextToken().getNextToken();
            while (true) {
                if (t2 != null && t2.isPaintable()) {
                    if (t2.getType() == 25) {
                        if (t2.is(CLOSE_TAG_START)) {
                            Token match = t2.getNextToken();
                            if (match != null && match.is(lexeme)) {
                                if (depth > 0) {
                                    --depth;
                                } else {
                                    try {
                                        int end = match.getOffset() + match.length();
                                        h2.addMarkedOccurrenceHighlight(match.getOffset(), end, p2);
                                        end = tokenOffs + match.length();
                                        h2.addMarkedOccurrenceHighlight(tokenOffs, end, p2);
                                        return;
                                    }
                                    catch (BadLocationException ble) {
                                        ble.printStackTrace();
                                    }
                                    return;
                                }
                            }
                        } else if (t2.isSingleChar('<') && (t2 = t2.getNextToken()) != null && t2.is(lexeme)) {
                            ++depth;
                        }
                    }
                    t2 = t2 == null ? null : t2.getNextToken();
                    continue;
                }
                if (++curLine < lineCount) {
                    t2 = doc.getTokenListForLine(curLine);
                }
                if (curLine >= lineCount) break;
            }
            return;
        }
        ArrayList<Entry> openCloses = new ArrayList<Entry>();
        boolean inPossibleMatch = false;
        t2 = doc.getTokenListForLine(curLine);
        int endBefore = tokenOffs - 2;
        while (true) {
            if (t2 != null && t2.getOffset() < endBefore && t2.isPaintable()) {
                if (t2.getType() == 25) {
                    Token next;
                    if (t2.isSingleChar('<')) {
                        Token next2 = t2.getNextToken();
                        if (next2 != null) {
                            if (next2.is(lexeme)) {
                                openCloses.add(new Entry(true, next2));
                                inPossibleMatch = true;
                            } else {
                                inPossibleMatch = false;
                            }
                            t2 = next2;
                        }
                    } else if (t2.isSingleChar('>')) {
                        inPossibleMatch = false;
                    } else if (inPossibleMatch && t2.is(TAG_SELF_CLOSE)) {
                        openCloses.remove(openCloses.size() - 1);
                        inPossibleMatch = false;
                    } else if (t2.is(CLOSE_TAG_START) && (next = t2.getNextToken()) != null) {
                        if (next.is(lexeme)) {
                            openCloses.add(new Entry(false, next));
                        }
                        t2 = next;
                    }
                }
                t2 = t2.getNextToken();
                continue;
            }
            for (int i2 = openCloses.size() - 1; i2 >= 0; --i2) {
                Entry entry = (Entry)openCloses.get(i2);
                if ((depth += entry.open ? -1 : 1) != -1) continue;
                try {
                    Token match = entry.t;
                    int end = match.getOffset() + match.length();
                    h2.addMarkedOccurrenceHighlight(match.getOffset(), end, p2);
                    end = tokenOffs + match.length();
                    h2.addMarkedOccurrenceHighlight(tokenOffs, end, p2);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                openCloses.clear();
                return;
            }
            openCloses.clear();
            if (--curLine >= 0) {
                t2 = doc.getTokenListForLine(curLine);
            }
            if (curLine < 0) break;
        }
    }

    private static class Entry {
        private boolean open;
        private Token t;

        Entry(boolean open, Token t2) {
            this.open = open;
            this.t = t2;
        }
    }
}

